<?php

require 'vendor/autoload.php';

use Aws\S3\S3Client;
use Aws\S3\Exception\S3Exception;

$key = 'YOUR_ACCESS_KEY';
$secret = 'YOUR_SECRET_KEY';
$bucket = 'c123456';
$domain = 'http://c123456.parspack.net';

$credentials = new Aws\Credentials\Credentials($key, $secret);

$s3 = new S3Client([
    'version' => 'latest',
    'region'  => 'us-west-2',
	'credentials' => $credentials,
	'endpoint' => $domain,
	'http'    => [
        'verify' => false
    ],
    'use_path_style_endpoint'   =>  true
]);

try {
	
	switch($argv[1]) {
		case 'list':
			$results = $s3->getPaginator('ListObjects', [
				'Bucket' => $bucket
			]);
			foreach ($results as $result) {
				foreach ($result['Contents'] as $object) {
					echo $object['Key'] . PHP_EOL;
				}
			}			
			break;
		case 'put':
			$sourceFilePath = 'parspack.png';
			$filePath = 'images/parspack.png';	
			$result = $s3->putObject([
				'Bucket' => $bucket,
				'Key' => $filePath,
				'SourceFile' => $sourceFilePath,
			]);
			echo 'Uploaded to: '.$filePath;
			break;
		case 'get':
			$targetPath = 'parspack-'.time().'.png';
			$filePath = 'images/parspack.png';
			$result = $s3->getObject([
				'Bucket' => $bucket,
				'Key' => $filePath,
				'SaveAs' => $targetPath
			]);
			echo 'Saved to: '.$targetPath;
			break;
		case 'delete':
			$filePath = 'images/parspack.png';
			$result = $s3->deleteObject([
				'Bucket' => $bucket,
				'Key' => $filePath
			]);
			echo 'File deleted: '.$filePath;
			break;
		default:
			echo 'Wrong argument.';
			break;
	}
	
} catch (S3Exception $e) {
    echo $e->getMessage() . PHP_EOL;
}
